/*
 * Decompiled with CFR 0.152.
 */
package com.hanweb.common.util.xml;

import com.hanweb.common.util.StringUtil;
import com.hanweb.common.util.log.Log;
import com.hanweb.common.util.log.LogFactory;
import com.hanweb.common.util.xml.XmlNode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XmlDocument {
    private static Log a = LogFactory.getInstance(XmlDocument.class);
    private String b = "utf-8";
    private Document c = null;
    private boolean d = false;
    private File e = null;

    public XmlDocument(String string) {
        this.b = string;
    }

    public XmlDocument() {
    }

    public void read(String string) {
        if (!StringUtil.isEmpty((String)string)) {
            try {
                this.c = DocumentHelper.parseText((String)string);
            }
            catch (DocumentException documentException) {
                a.error((Object)"create XmlDocument error", (Throwable)documentException);
            }
        }
    }

    public void readFromPath(String string) {
        if (!StringUtil.isEmpty((String)string)) {
            this.read(new File(string));
        }
    }

    public void read(File file) {
        this.e = file;
        if (file.exists()) {
            SAXReader sAXReader = new SAXReader();
            sAXReader.setValidation(false);
            sAXReader.setEncoding(this.b);
            try {
                this.c = sAXReader.read(file);
            }
            catch (DocumentException documentException) {
                a.error((Object)"create XmlDocument error", (Throwable)documentException);
            }
        }
    }

    public void createRoot(String string) {
        Element element;
        if (StringUtil.isEmpty((String)string)) {
            return;
        }
        if (this.c == null) {
            this.c = DocumentHelper.createDocument();
        }
        if ((element = this.c.getRootElement()) == null) {
            this.c.addElement(string);
        }
    }

    public XmlNode getXmlNode(String string) {
        XmlNode xmlNode = null;
        if (this.c == null || StringUtil.isEmpty((String)string)) {
            return xmlNode;
        }
        Node node = this.c.selectSingleNode(string);
        if (node != null) {
            xmlNode = this.a(node);
        }
        return xmlNode;
    }

    public List<XmlNode> getXmlNodes(String string) {
        ArrayList<XmlNode> arrayList = null;
        if (this.c == null || StringUtil.isEmpty((String)string)) {
            return arrayList;
        }
        List list = this.c.selectNodes(string);
        if (list != null) {
            arrayList = new ArrayList<XmlNode>();
            XmlNode xmlNode = null;
            for (Node node : list) {
                xmlNode = this.a(node);
                arrayList.add(xmlNode);
            }
        }
        return arrayList;
    }

    public boolean isExist(String string) {
        boolean bl = false;
        if (this.c == null || StringUtil.isEmpty((String)string)) {
            return bl;
        }
        Node node = this.c.selectSingleNode(string);
        if (node != null) {
            bl = true;
        }
        return bl;
    }

    public boolean createPath(String string) {
        boolean bl = false;
        if (StringUtil.isEmpty((String)string)) {
            return bl;
        }
        Element element = null;
        if (this.c == null) {
            this.c = DocumentHelper.createDocument();
        }
        element = this.c.getRootElement();
        Element element2 = StringUtil.split((String)string, (String)"/");
        if (element2 == null) {
            return bl;
        }
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (String string2 : element2) {
            if (StringUtil.isEmpty((String)string2)) continue;
            arrayList.add(DocumentHelper.createElement((String)string2));
        }
        if (element == null) {
            this.c.add((Element)arrayList.get(0));
            element = this.c.getRootElement();
        }
        if (element.getName().equals(((Element)arrayList.get(0)).getName())) {
            arrayList.remove(0);
        }
        Collections.reverse(arrayList);
        Element element3 = null;
        for (Element element4 : arrayList) {
            if (element3 != null) {
                element4.add(element3);
            }
            element3 = element4;
        }
        element.add(element3);
        return bl;
    }

    public boolean addNodeCDATA(String string, String string2, String string3) {
        return this.addNode(string, string2, string3, null, true);
    }

    public boolean addNode(String string, String string2, String string3) {
        return this.addNode(string, string2, string3, null, false);
    }

    public boolean addNode(String string, String string2, String string3, Map<String, String> map, boolean bl) {
        Element element;
        boolean bl2 = false;
        if (StringUtil.isEmpty((String)string) || StringUtil.isEmpty((String)string2)) {
            return bl2;
        }
        if (StringUtil.isEmpty((String)string3)) {
            string3 = "";
        }
        if (this.c == null) {
            this.createRoot(string.split("/")[0]);
        }
        if ((element = (Element)this.c.selectSingleNode(string)) == null) {
            this.createPath(string);
            element = (Element)this.c.selectSingleNode(string);
            if (element == null) {
                return bl2;
            }
        }
        Element element2 = DocumentHelper.createElement((String)string2);
        if (bl) {
            element2.addCDATA(string3);
        } else {
            element2.setText(string3);
        }
        if (map != null) {
            Set<Map.Entry<String, String>> set = map.entrySet();
            for (Map.Entry<String, String> entry : set) {
                element2.addAttribute(entry.getKey(), entry.getValue());
            }
        }
        element.add(element2);
        bl2 = true;
        return bl2;
    }

    public boolean updateNodeCDATA(String string, String string2) {
        return this.updateNode(string, string2, null, true);
    }

    public boolean updateNode(String string, String string2) {
        return this.updateNode(string, string2, null, false);
    }

    public boolean updateNode(String string, String string2, Map<String, String> map, boolean bl) {
        List list;
        boolean bl2 = false;
        if (this.c == null || StringUtil.isEmpty((String)string)) {
            return bl2;
        }
        if (StringUtil.isEmpty((String)string2)) {
            string2 = "";
        }
        if ((list = this.c.selectNodes(string)) != null) {
            for (Node node : list) {
                Element element = (Element)node;
                element.clearContent();
                if (bl) {
                    element.addCDATA(string2);
                } else {
                    element.setText(string2);
                }
                if (map == null) continue;
                Set<Map.Entry<String, String>> set = map.entrySet();
                for (Map.Entry<String, String> entry : set) {
                    element.addAttribute(entry.getKey(), entry.getValue());
                }
            }
            bl2 = true;
        }
        return bl2;
    }

    public boolean removeNode(String string) {
        boolean bl = false;
        if (this.c == null || StringUtil.isEmpty((String)string)) {
            return bl;
        }
        List list = this.c.selectNodes(string);
        if (list != null) {
            for (Node node : list) {
                node.detach();
                this.c.remove(node);
            }
            bl = true;
        }
        return bl;
    }

    public boolean save() {
        if (this.e == null) {
            a.error((Object)"save error file is null");
            return false;
        }
        return this.saveAs(this.e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveAs(File file) {
        boolean bl = false;
        OutputFormat outputFormat = OutputFormat.createPrettyPrint();
        outputFormat.setEncoding(this.b);
        XMLWriter xMLWriter = null;
        try {
            if (!file.exists()) {
                FileUtils.touch((File)file);
            }
            xMLWriter = new XMLWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file, this.d), this.b), outputFormat);
            xMLWriter.write(this.c);
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            a.error((Object)"save error", (Throwable)exception);
        }
        finally {
            if (xMLWriter != null) {
                try {
                    xMLWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    private XmlNode a(Node node) {
        XmlNode xmlNode = new XmlNode();
        xmlNode.b(node.getName());
        xmlNode.c(node.getPath());
        xmlNode.a(node.getStringValue());
        xmlNode.d(node.getText());
        List list = ((Element)node).attributes();
        for (Attribute attribute : list) {
            xmlNode.a(attribute.getName(), attribute.getStringValue());
        }
        return xmlNode;
    }

    public void setEncoding(String string) {
        this.b = string;
    }
}

