/*
 * Decompiled with CFR 0.152.
 */
package com.hanweb.common.util.ip;

import com.hanweb.boot.autoconfiguration.PlatformProperties;
import com.hanweb.common.util.CollectionUtil;
import com.hanweb.common.util.SpringUtil;
import com.hanweb.common.util.StringUtil;
import com.hanweb.common.util.ip.IpCustomUtil;
import com.hanweb.common.util.ip.IpDataSeeker;
import com.hanweb.common.util.log.Log;
import com.hanweb.common.util.log.LogFactory;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressSeqRange;
import inet.ipaddr.IPAddressString;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class IpUtil {
    private static Log a = LogFactory.getInstance(IpUtil.class);
    private static String b = "x-forwarded-for";

    public static byte[] getIpByteArrayFromString(String string) {
        byte[] byArray = new byte[4];
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        try {
            byArray[0] = (byte)(Integer.parseInt(stringTokenizer.nextToken()) & 0xFF);
            byArray[1] = (byte)(Integer.parseInt(stringTokenizer.nextToken()) & 0xFF);
            byArray[2] = (byte)(Integer.parseInt(stringTokenizer.nextToken()) & 0xFF);
            byArray[3] = (byte)(Integer.parseInt(stringTokenizer.nextToken()) & 0xFF);
        }
        catch (Exception exception) {
            String string2 = string;
            a.warn((Object)new StringBuilder(50).append("getIpByteArrayFromString error ip:").append(string2).toString());
        }
        return byArray;
    }

    public static String getString(String string, String string2, String string3) {
        try {
            return new String(string.getBytes(string2), string3);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static String getString(byte[] byArray, String string) {
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray);
        }
    }

    public static String getString(byte[] byArray, int n, int n2, String string) {
        try {
            return new String(byArray, n, n2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray, n, n2);
        }
    }

    public static String getIpStringFromBytes(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(byArray[0] & 0xFF);
        stringBuffer.append('.');
        stringBuffer.append(byArray[1] & 0xFF);
        stringBuffer.append('.');
        stringBuffer.append(byArray[2] & 0xFF);
        stringBuffer.append('.');
        stringBuffer.append(byArray[3] & 0xFF);
        return stringBuffer.toString();
    }

    public static String getAddressByIP(String string) {
        String string2 = IpCustomUtil.getAddressByIP(string);
        if (StringUtil.isEmpty((String)string2)) {
            IpDataSeeker ipDataSeeker = IpDataSeeker.getInstance();
            string2 = ipDataSeeker.getAddress(string);
        }
        return string2;
    }

    public static String getCountryByIP(String string) {
        String string2 = IpCustomUtil.getCountryByIP(string);
        if (StringUtil.isEmpty((String)string2)) {
            IpDataSeeker ipDataSeeker = IpDataSeeker.getInstance();
            string2 = ipDataSeeker.getCountry(string);
        }
        return string2;
    }

    public static String getAreaByIP(String string) {
        String string2 = IpCustomUtil.getAreaByIP(string);
        if (StringUtil.isEmpty((String)string2)) {
            IpDataSeeker ipDataSeeker = IpDataSeeker.getInstance();
            string2 = ipDataSeeker.getArea(string);
        }
        return string2;
    }

    public static String getIp() {
        HttpServletRequest httpServletRequest = SpringUtil.getRequest();
        return IpUtil.getIp(httpServletRequest);
    }

    public static String getAllIp() {
        HttpServletRequest httpServletRequest = SpringUtil.getRequest();
        return IpUtil.getAllIp(httpServletRequest);
    }

    public static String getAllIp(HttpServletRequest httpServletRequest) {
        String string;
        String string2;
        if (httpServletRequest == null) {
            return "";
        }
        String string3 = string2 = httpServletRequest.getHeader(b);
        String string4 = b;
        a.debug((Object)new StringBuilder(49).append("load ip from ").append(string4).append(" is ").append(string3).toString());
        string3 = string = httpServletRequest.getHeader("http_client_ip");
        a.debug((Object)new StringBuilder(47).append("load ip from http_client_ip is ").append(string3).toString());
        String string5 = "unknown";
        String string6 = null;
        if (string2 != null && !string2.equalsIgnoreCase(string5) && string2.trim().length() > 0) {
            string3 = string6 = string2;
            string4 = b;
            a.debug((Object)new StringBuilder(48).append("get ip from ").append(string4).append(" is ").append(string3).toString());
        } else if (string != null && !string.equalsIgnoreCase(string5) && string.trim().length() > 0) {
            string3 = string6 = string;
            a.debug((Object)new StringBuilder(46).append("get ip from http_client_ip is ").append(string3).toString());
        } else {
            string3 = string6 = httpServletRequest.getRemoteAddr();
            a.debug((Object)new StringBuilder(42).append("get ip from RemoteAddr is ").append(string3).toString());
        }
        return string6;
    }

    public static String getIp(HttpServletRequest httpServletRequest) {
        String string = IpUtil.getAllIp(httpServletRequest);
        if (StringUtil.isNotEmpty((String)string)) {
            string = string.split(",")[0];
        }
        string = IpUtil.washIpV6(string);
        return string;
    }

    public static String longToIp(long l) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(String.valueOf(l >>> 24));
        stringBuffer.append(".");
        stringBuffer.append(String.valueOf((l & 0xFFFFFFL) >>> 16));
        stringBuffer.append(".");
        stringBuffer.append(String.valueOf((l & 0xFFFFL) >>> 8));
        stringBuffer.append(".");
        stringBuffer.append(String.valueOf(l & 0xFFL));
        return stringBuffer.toString();
    }

    public static final long ipToLong(String string) {
        long l = 0L;
        try {
            int n;
            string = string.equals("0:0:0:0:0:0:0:1") ? "127.0.0.1" : string;
            String[] stringArray = string.split("\\.");
            for (n = 0; n < stringArray.length; ++n) {
                l <<= 8;
                l += Long.parseLong(stringArray[n]);
            }
            for (n = stringArray.length; n < 4; ++n) {
                l <<= 8;
            }
        }
        catch (Exception exception) {
            String string2 = string;
            a.warn((Object)new StringBuilder(32).append("ipToLong failed:").append(string2).toString());
        }
        return l;
    }

    public static String getIpHead() {
        return b;
    }

    public static void setIpHead(String string) {
        b = string;
    }

    public static String washIpV6(String string) {
        if (StringUtil.isNotEmpty((String)string) && string.indexOf("%") > -1) {
            string = string.split("%")[0];
        }
        return string;
    }

    public static boolean isIpV4(String string) {
        boolean bl = false;
        if (StringUtil.isNotEmpty((String)string)) {
            string = StringUtil.trim((Object)string);
            bl = Pattern.matches("^(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])$", string);
        }
        return bl;
    }

    public static boolean isIpV6(String string) {
        boolean bl = false;
        if (StringUtil.isNotEmpty((String)string)) {
            string = StringUtil.trim((Object)string);
            string = IpUtil.washIpV6(string);
            bl = Pattern.matches("^((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?$", string);
        }
        return bl;
    }

    public static boolean range(String string, String string2, String string3) throws Exception {
        IPAddress iPAddress = new IPAddressString(string).toAddress();
        IPAddress iPAddress2 = new IPAddressString(string2).toAddress();
        IPAddress iPAddress3 = new IPAddressString(string3).toAddress();
        IPAddressSeqRange iPAddressSeqRange = iPAddress.toSequentialRange(iPAddress2);
        boolean bl = iPAddressSeqRange.contains(iPAddress3);
        IPAddress iPAddress4 = iPAddress3;
        IPAddressSeqRange iPAddressSeqRange2 = iPAddressSeqRange;
        a.debug((Object)new StringBuilder(48).append(iPAddressSeqRange2).append(" contains ").append(iPAddress4).append(" ").append(bl).toString());
        return iPAddressSeqRange.contains(iPAddress3);
    }

    public static String getLocalIp() {
        String string = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostAddress();
        }
        catch (Exception exception) {
            a.error((Object)"getLocalIp error", (Throwable)exception);
        }
        return string;
    }

    static {
        Collection collection = SpringUtil.getBeans(PlatformProperties.class);
        if (CollectionUtil.isNotEmpty(collection)) {
            b = ((PlatformProperties)collection.iterator().next()).getIpHead();
        }
    }
}

