/*
 * Decompiled with CFR 0.152.
 */
package com.hanweb.common.util.ip;

import com.hanweb.common.util.ClassPathUtil;
import com.hanweb.common.util.ip.IPLocation;
import com.hanweb.common.util.ip.IpUtil;
import com.hanweb.common.util.log.Log;
import com.hanweb.common.util.log.LogFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.concurrent.locks.ReentrantLock;

public class IpDataSeeker {
    private static Log a = LogFactory.getInstance(IpDataSeeker.class);
    private Hashtable<String, IPLocation> b;
    private byte[] c;
    private long d;
    private long e;
    private long f;
    private static ReentrantLock g = new ReentrantLock();
    private static IpDataSeeker h = new IpDataSeeker();

    public static IpDataSeeker getInstance() {
        return h;
    }

    private IpDataSeeker() {
        try {
            this.a();
        }
        catch (Exception exception) {
            a.error((Object)"IpDataSeeker load error", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = null;
        InputStream inputStream = null;
        g.lock();
        try {
            this.b = new Hashtable();
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            inputStream = ClassPathUtil.getContentPossibleAsStream((String)"/data/ipsite.dat");
            while (inputStream.read(byArray) != -1) {
                byteArrayOutputStream.write(byArray);
            }
            this.c = byteArrayOutputStream.toByteArray();
            this.d = this.a(0);
            this.e = this.a(4);
            this.f = (this.e - this.d) / 7L + 1L;
            inputStream.close();
            byteArrayOutputStream.close();
        }
        finally {
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            g.unlock();
        }
    }

    private long a(int n) {
        long l = this.c[n] & 0xFF;
        l |= (long)(this.c[n + 1] << 8) & 0xFF00L;
        l |= (long)(this.c[n + 2] << 16) & 0xFF0000L;
        return l |= (long)(this.c[n + 3] << 24) & 0xFF000000L;
    }

    private long b(int n) {
        long l = this.c[n] & 0xFF;
        l |= (long)(this.c[n + 1] << 8 & 0xFF00);
        return l |= (long)(this.c[n + 2] << 16 & 0xFF0000);
    }

    private long a(long l) {
        long l2 = 0L;
        long l3 = this.f;
        long l4 = 0L;
        while (l2 <= l3) {
            l4 = l2 + l3 >>> 1;
            long l5 = this.a((int)(this.d + (l4 - 1L) * 7L));
            long l6 = this.a((int)(this.d + l4 * 7L));
            if (l5 <= l && l < l6) {
                return this.b((int)(this.d + (l4 - 1L) * 7L + 4L));
            }
            if (l > l5) {
                l2 = l4 + 1L;
                continue;
            }
            if (l >= l5) continue;
            l3 = l4 - 1L;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPLocation fetchIPLocation(String string) {
        long l = IpDataSeeker.a(string);
        g.lock();
        long l2 = this.a(l);
        try {
            if (l2 != -1L) {
                IPLocation iPLocation = this.c((int)l2);
                return iPLocation;
            }
        }
        finally {
            g.unlock();
        }
        return null;
    }

    private IPLocation c(int n) {
        IPLocation iPLocation = new IPLocation();
        try {
            byte by = this.c[n + 4];
            if (by == 1) {
                long l = this.b(n + 5);
                by = this.c[(int)l];
                if (by == 2) {
                    a a2 = this.e((int)this.b((int)l + 1));
                    iPLocation.country = a2.a;
                    l += 4L;
                } else {
                    a a3 = this.e((int)l);
                    iPLocation.country = a3.a;
                    l += (long)a3.b;
                }
                iPLocation.area = this.d((int)l);
            } else if (by == 2) {
                iPLocation.country = this.e((int)((int)this.b((int)(n + 5)))).a;
                iPLocation.area = this.d(n + 8);
            } else {
                a a4 = this.e(n + 4);
                iPLocation.country = a4.a;
                iPLocation.area = this.d(n + 4 + a4.b);
            }
            return iPLocation;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String d(int n) {
        byte by = this.c[n];
        if (by == 1 || by == 2) {
            long l = this.b(n + 1);
            if (l == 0L) {
                return "";
            }
            return this.e((int)((int)l)).a;
        }
        return this.e((int)n).a;
    }

    private a e(int n) {
        int n2 = n;
        byte[] byArray = new byte[128];
        int n3 = 0;
        byArray[n3] = this.c[n2++];
        while (byArray[n3] != 0) {
            byArray[++n3] = this.c[n2++];
        }
        try {
            return new a(new String(byArray, 0, n3, "GBK"), n3 + 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new a("", 0);
        }
    }

    private static long a(String string) {
        if (string == null) {
            throw new NullPointerException("ip\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] stringArray = string.split("\\.");
        long l = (Long.parseLong(stringArray[0]) & 0xFFL) << 24 & 0xFF000000L;
        l |= (Long.parseLong(stringArray[1]) & 0xFFL) << 16 & 0xFF0000L;
        l |= (Long.parseLong(stringArray[2]) & 0xFFL) << 8 & 0xFF00L;
        return l |= Long.parseLong(stringArray[3]) & 0xFFL;
    }

    public String getCountry(byte[] byArray) {
        if (this.c == null) {
            return "\u9519\u8bef\u7684IP\u6570\u636e\u5e93\u6587\u4ef6";
        }
        String string = IpUtil.getIpStringFromBytes(byArray);
        if (this.b.containsKey(string)) {
            IPLocation iPLocation = this.b.get(string);
            return iPLocation.country;
        }
        IPLocation iPLocation = this.fetchIPLocation(string);
        this.b.put(string, iPLocation.getCopy());
        return iPLocation.country;
    }

    public String getCountry(String string) {
        return this.getCountry(IpUtil.getIpByteArrayFromString(string));
    }

    public String getArea(byte[] byArray) {
        String string = "";
        if (this.c == null) {
            string = "\u9519\u8bef\u7684IP\u6570\u636e\u5e93\u6587\u4ef6";
        } else {
            IPLocation iPLocation = null;
            String string2 = IpUtil.getIpStringFromBytes(byArray);
            if (this.b.containsKey(string2)) {
                iPLocation = this.b.get(string2);
            } else {
                iPLocation = this.fetchIPLocation(string2);
                this.b.put(string2, iPLocation.getCopy());
            }
            string = iPLocation.area;
            iPLocation = null;
            string2 = null;
        }
        return string;
    }

    public String getArea(String string) {
        return this.getArea(IpUtil.getIpByteArrayFromString(string));
    }

    public String getAddress(String string) {
        String string2 = "";
        string2 = this.getCountry(string).equals(" CZ88.NET") ? "" : this.getCountry(string);
        String string3 = "";
        string3 = this.getArea(string).equals(" CZ88.NET") ? "" : this.getArea(string);
        String string4 = string3;
        String string5 = string2;
        String string6 = new StringBuilder(33).append(string5).append(" ").append(string4).toString();
        return string6.trim();
    }

    private class a {
        public final String a;
        public final int b;

        public a(String string, int n) {
            this.a = string;
            this.b = n;
        }

        public String toString() {
            return this.a;
        }
    }
}

