/*
 * Decompiled with CFR 0.152.
 */
package com.hanweb.common.util.document;

import com.hanweb.common.algorithm.StringSimilarity;
import com.hanweb.common.util.StringUtil;
import com.hanweb.common.util.document.entity.ContentSimilarity;
import com.hanweb.common.util.document.entity.ContentSimilarityLocation;
import com.hanweb.common.util.log.Log;
import com.hanweb.common.util.log.LogFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class DocUtil {
    private static final Log a = LogFactory.getInstance(DocUtil.class);
    private static final Pattern b = Pattern.compile("[!?\u3002\uff1f\uff01;\uff1b\r\n]");

    public static List<List<ContentSimilarityLocation>> similarTextLocation(String string, String string2, boolean bl) {
        List<String> list = DocUtil.splitIntoSentences(string);
        List<String> list2 = DocUtil.splitIntoSentences(string2);
        ArrayList<List<ContentSimilarityLocation>> arrayList = new ArrayList<List<ContentSimilarityLocation>>();
        for (String string3 : list2) {
            Object object;
            ArrayList<ContentSimilarity> arrayList2 = new ArrayList<ContentSimilarity>();
            for (String string4 : list) {
                double d;
                if (bl) {
                    String string5 = StringUtil.removeHTML((String)string4);
                    object = StringUtil.removeHTML((String)string3);
                    d = StringSimilarity.calculateSimilarity((String)string5, (String)object);
                } else {
                    d = StringSimilarity.calculateSimilarity((String)string4, (String)string3);
                }
                arrayList2.add(new ContentSimilarity(string4, d));
            }
            arrayList2.sort((contentSimilarity, contentSimilarity2) -> (int)(contentSimilarity2.getSimilar() * 1000.0 - contentSimilarity.getSimilar() * 1000.0));
            int n = string3.length();
            double d = 0.5;
            if (n < 10) {
                d = 0.8;
            } else if (n < 30) {
                d = 0.65;
            }
            ArrayList<ContentSimilarityLocation> arrayList3 = new ArrayList<ContentSimilarityLocation>();
            for (int i = 0; i < arrayList2.size() && i < 2; ++i) {
                object = (ContentSimilarity)arrayList2.get(i);
                if (!(((ContentSimilarity)object).getSimilar() > d)) continue;
                String string6 = ((ContentSimilarity)object).getSentence();
                int n2 = string.indexOf(string6);
                arrayList3.add(new ContentSimilarityLocation(string6, n2, n2 + string6.length()));
            }
            arrayList.add(arrayList3);
        }
        return arrayList;
    }

    public static List<List<ContentSimilarityLocation>> similarTextLocation(String string, String string2) {
        return DocUtil.similarTextLocation(string, string2, false);
    }

    public static List<String> splitIntoSentences(String string) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray = string.split(b.pattern())) {
            if ((string2 = string2.trim()).isEmpty()) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static double coverage(String string, List<String> list) {
        return DocUtil.noDeduplicationCoverage(string, list, 1);
    }

    public static double noDeduplicationCoverage(String string, List<String> list, int n) {
        if (n < 1) {
            n = 1;
        }
        int[] nArray = new int[string.length()];
        for (String string2 : list) {
            List<List<ContentSimilarityLocation>> list2 = DocUtil.similarTextLocation(string, string2);
            for (List<ContentSimilarityLocation> list3 : list2) {
                for (ContentSimilarityLocation contentSimilarityLocation : list3) {
                    int n2 = contentSimilarityLocation.getStart();
                    int n3 = contentSimilarityLocation.getEnd();
                    for (int i = n2; i <= n3 && i < nArray.length; ++i) {
                        if (n == 1) {
                            nArray[i] = 1;
                            continue;
                        }
                        if (n < 3 && nArray[i] < n) {
                            int n4 = i;
                            nArray[n4] = nArray[n4] + 1;
                            continue;
                        }
                        if (n < 6 && nArray[i] < n + 1) {
                            int n5 = i;
                            nArray[n5] = nArray[n5] + 1;
                            continue;
                        }
                        if (n > 6 && n < 11 && nArray[i] < n + 2) {
                            int n6 = i;
                            nArray[n6] = nArray[n6] + 1;
                            continue;
                        }
                        if (n <= 10 || nArray[i] >= n + 3) continue;
                        int n7 = i;
                        nArray[n7] = nArray[n7] + 1;
                    }
                }
            }
        }
        int n8 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (nArray[i] > 0) {
                n8 += nArray[i];
                continue;
            }
            if (string.charAt(i) != '\n') continue;
            n8 += n;
        }
        double d = (double)n8 * 1.0 / (double)string.length();
        a.debug((Object)new StringBuilder(26).append("\u8986\u76d6\u7387").append(d).toString());
        return (double)n8 * 1.0 / (double)string.length();
    }
}

