/*
 * Decompiled with CFR 0.152.
 */
package com.hanweb.common.util.cache;

import com.hanweb.common.ConfigManager;
import com.hanweb.common.util.StringUtil;
import com.hanweb.common.util.cache.ICacheSearch;
import com.hanweb.common.util.cache.ICacheSearchAttr;
import com.hanweb.common.util.log.Log;
import com.hanweb.common.util.log.LogFactory;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.PersistenceConfiguration;
import net.sf.ehcache.config.Searchable;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Direction;
import net.sf.ehcache.search.Query;
import net.sf.ehcache.search.Result;
import net.sf.ehcache.search.Results;
import org.apache.commons.io.IOUtils;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component(value="com.hanweb.common.util.cache.EhCacheHandle")
@DependsOn(value={"ConfigManager"})
public class EhCacheHandle {
    private static Log a = LogFactory.getInstance(EhCacheHandle.class);
    private static CacheManager b = CacheManager.create();
    private static String c = "hanweb";
    private Cache d = null;

    public EhCacheHandle() {
    }

    @PostConstruct
    public void init() {
        System.out.println("init EhCacheHandle");
        try {
            String string = ConfigManager.getInstance().getContent("/data/config/ehcache.xml");
            if (StringUtil.isNotEmpty((String)string)) {
                b = CacheManager.create((InputStream)IOUtils.toInputStream((String)string, (String)"utf-8"));
            }
        }
        catch (Exception exception) {
            a.error((Object)"EhCacheHandle init error", (Throwable)exception);
        }
    }

    public static void createCache(String string, int n, boolean bl, boolean bl2, long l, long l2) {
        EhCacheHandle.createCache(string, n, bl, bl2, l, l2, null);
    }

    public static void createCache(String string, int n, boolean bl, boolean bl2, long l, long l2, ICacheSearchAttr iCacheSearchAttr) {
        Searchable searchable;
        CacheConfiguration cacheConfiguration = new CacheConfiguration();
        cacheConfiguration.setName(string);
        cacheConfiguration.setMaxEntriesLocalHeap((long)n);
        PersistenceConfiguration persistenceConfiguration = new PersistenceConfiguration();
        if (bl) {
            cacheConfiguration.persistence(persistenceConfiguration.strategy(PersistenceConfiguration.Strategy.LOCALTEMPSWAP));
        } else {
            cacheConfiguration.persistence(persistenceConfiguration.strategy(PersistenceConfiguration.Strategy.NONE));
        }
        cacheConfiguration.setEternal(bl2);
        cacheConfiguration.setTimeToLiveSeconds(l);
        cacheConfiguration.setTimeToIdleSeconds(l2);
        if (!bl) {
            searchable = new Searchable();
            if (iCacheSearchAttr != null) {
                iCacheSearchAttr.configSearchAttr(searchable);
            }
            cacheConfiguration.searchable(searchable);
        }
        searchable = new Cache(cacheConfiguration);
        b.addCache((Cache)searchable);
    }

    public static boolean isExist(String string) {
        boolean bl = false;
        Cache cache = b.getCache(string);
        if (cache != null) {
            bl = true;
        }
        return bl;
    }

    private EhCacheHandle(String string) {
        this.d = b.getCache(string);
    }

    public static EhCacheHandle getInstance(String string) {
        EhCacheHandle ehCacheHandle = new EhCacheHandle(string);
        return ehCacheHandle;
    }

    public static EhCacheHandle getInstanceDefault() {
        if (!EhCacheHandle.isExist(c)) {
            EhCacheHandle.createCache(c, 0, false, true, 0L, 0L);
        }
        EhCacheHandle ehCacheHandle = new EhCacheHandle(c);
        return ehCacheHandle;
    }

    public void addValue(Object object, Object object2) {
        Element element = new Element(object, object2);
        this.d.put(element);
    }

    public <T> T getValue(Object object) {
        Element element = this.d.get(object);
        if (element == null) {
            return null;
        }
        Object object2 = element.getObjectValue();
        return (T)object2;
    }

    public <T> List<T> getAllKey() {
        return this.d.getKeys();
    }

    public boolean isKeyExsit(Object object) {
        return this.d.isKeyInCache(object);
    }

    public boolean isValueExsit(Object object) {
        return this.d.isValueInCache(object);
    }

    public boolean remove(Object object) {
        return this.d.remove(object);
    }

    public boolean remove(Collection<?> collection) {
        this.d.removeAll(collection);
        return true;
    }

    public boolean removeKeyContains(String string) {
        boolean bl = false;
        if (StringUtil.isNotEmpty((String)string)) {
            String string2 = string;
            bl = this.a(new StringBuilder(18).append("*").append(string2).append("*").toString());
        }
        return bl;
    }

    public boolean removeKeyStartsWith(String string) {
        boolean bl = false;
        if (StringUtil.isNotEmpty((String)string)) {
            String string2 = string;
            bl = this.a(new StringBuilder(17).append(string2).append("*").toString());
        }
        return bl;
    }

    public boolean removeKeyEndsWith(String string) {
        boolean bl = false;
        if (StringUtil.isNotEmpty((String)string)) {
            String string2 = string;
            bl = this.a(new StringBuilder(17).append("*").append(string2).toString());
        }
        return bl;
    }

    public <T> Attribute<T> createSearchAttribute(String string) {
        return this.d.getSearchAttribute(string);
    }

    private boolean a(String string) {
        boolean bl = false;
        if (StringUtil.isNotEmpty((String)string)) {
            Attribute attribute = this.d.getSearchAttribute("key");
            Results results = this.a(true, true).addCriteria(attribute.ilike(string)).execute();
            if (results != null && results.hasKeys()) {
                List list = results.all();
                for (Result result : list) {
                    this.d.remove(result.getKey());
                }
                bl = true;
            }
        }
        return bl;
    }

    private Query a(boolean bl, boolean bl2) {
        Query query = this.d.createQuery();
        if (bl) {
            query.includeKeys();
        }
        if (bl2) {
            query.includeValues();
        }
        return query;
    }

    public <T> List<T> search(ICacheSearch<T> iCacheSearch) {
        return iCacheSearch.search(this);
    }

    public <T> List<T> getKeyContains(String string) {
        List<T> list = null;
        if (StringUtil.isNotEmpty((String)string)) {
            String string2 = string;
            list = this.b(new StringBuilder(18).append("*").append(string2).append("*").toString());
        }
        return list;
    }

    public <T> List<T> getKeyEndsWith(String string) {
        List<T> list = null;
        if (StringUtil.isNotEmpty((String)string)) {
            String string2 = string;
            list = this.b(new StringBuilder(17).append("*").append(string2).toString());
        }
        return list;
    }

    public <T> List<T> getKeyStartsWith(String string) {
        List<T> list = null;
        if (StringUtil.isNotEmpty((String)string)) {
            String string2 = string;
            list = this.b(new StringBuilder(17).append(string2).append("*").toString());
        }
        return list;
    }

    private <T> List<T> b(String string) {
        Query query = this.a(true, true);
        Attribute<T> attribute = this.createSearchAttribute("key");
        Results results = query.addCriteria(attribute.ilike(string)).addOrderBy(attribute, Direction.ASCENDING).execute();
        ArrayList<Object> arrayList = null;
        if (results != null && results.hasKeys()) {
            arrayList = new ArrayList<Object>();
            List list = results.all();
            for (Result result : list) {
                arrayList.add(result.getValue());
            }
        }
        return arrayList;
    }

    public Cache getCache() {
        return this.d;
    }

    public boolean removeAll() {
        this.d.removeAll();
        return true;
    }

    public static void close() {
        a.info((Object)"shutdown cache start");
        b.removeAllCaches();
        b.shutdown();
        a.info((Object)"shutdown cache finish");
    }

    public static void main(String[] stringArray) {
        EhCacheHandle.createCache("xx", 200, true, false, 500000L, 50000L);
        EhCacheHandle ehCacheHandle = EhCacheHandle.getInstance("xx");
        ehCacheHandle.getKeyStartsWith("aa");
    }
}

