/*
 * Decompiled with CFR 0.152.
 */
package com.hanweb.common.util;

import com.hanweb.common.cache.MimeTypeCache;
import com.hanweb.common.util.CollectionUtil;
import com.hanweb.common.util.NumberUtil;
import com.hanweb.common.util.StringUtil;
import com.hanweb.common.util.log.Log;
import com.hanweb.common.util.log.LogFactory;
import info.monitorenter.cpdetector.io.ASCIIDetector;
import info.monitorenter.cpdetector.io.CodepageDetectorProxy;
import info.monitorenter.cpdetector.io.ICodepageDetector;
import info.monitorenter.cpdetector.io.JChardetFacade;
import info.monitorenter.cpdetector.io.ParsingDetector;
import info.monitorenter.cpdetector.io.UnicodeDetector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.ArrayUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import sviolet.smcrypto.SmCryptoUtil;

public class FileUtil {
    private static Log a = LogFactory.getInstance(FileUtil.class);
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    public static final String[] EXCEL_FILE = new String[]{"xls"};
    public static final String[] WORD_FILE = new String[]{"doc"};
    public static final String DEFAULT_MIMETYPE = "application/octet-stream";

    public static boolean copyFile(String string, String string2) {
        if (StringUtil.isNotEmpty((String)string) && StringUtil.isNotEmpty((String)string2)) {
            return FileUtil.copyFile(new File(string), new File(string2));
        }
        return false;
    }

    public static boolean copyFile(File file, File file2) {
        boolean bl = false;
        try {
            FileUtils.copyFile((File)file, (File)file2);
            bl = true;
        }
        catch (Exception exception) {
            a.error((Object)"copyFile error", (Throwable)exception);
        }
        return bl;
    }

    public static boolean moveFile(String string, String string2) {
        if (StringUtil.isNotEmpty((String)string) && StringUtil.isNotEmpty((String)string2)) {
            return FileUtil.moveFile(new File(string), new File(string2));
        }
        return false;
    }

    public static boolean moveFile(File file, File file2) {
        boolean bl = false;
        try {
            FileUtils.moveFile((File)file, (File)file2);
            bl = true;
        }
        catch (Exception exception) {
            a.error((Object)"moveFile error", (Throwable)exception);
        }
        return bl;
    }

    public static boolean moveFileToDirectory(String string, String string2) {
        if (StringUtil.isNotEmpty((String)string) && StringUtil.isNotEmpty((String)string2)) {
            return FileUtil.moveFileToDirectory(new File(string), new File(string2));
        }
        return false;
    }

    public static boolean moveFileToDirectory(File file, File file2) {
        boolean bl = false;
        try {
            FileUtils.moveFileToDirectory((File)file, (File)file2, (boolean)true);
            bl = true;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            a.error((Object)new StringBuilder(41).append("moveFileToDirectory error").append(string).toString());
        }
        return bl;
    }

    public static boolean copyFileToDirectory(String string, String string2) {
        if (StringUtil.isNotEmpty((String)string) && StringUtil.isNotEmpty((String)string2)) {
            return FileUtil.copyFileToDirectory(new File(string), new File(string2));
        }
        return false;
    }

    public static boolean copyFileToDirectory(File file, File file2) {
        boolean bl = false;
        try {
            FileUtils.copyFileToDirectory((File)file, (File)file2);
            bl = true;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            a.error((Object)new StringBuilder(48).append("copyFileToDirectory(File, File):").append(string).toString());
        }
        return bl;
    }

    public static boolean copyDirectory(String string, String string2) {
        if (StringUtil.isNotEmpty((String)string) && StringUtil.isNotEmpty((String)string2)) {
            return FileUtil.copyDirectory(new File(string), new File(string2));
        }
        return false;
    }

    public static boolean copyDirectory(File file, File file2) {
        boolean bl = false;
        try {
            FileUtils.copyDirectory((File)file, (File)file2);
            bl = true;
        }
        catch (Exception exception) {
            a.error((Object)"copyDirectory error", (Throwable)exception);
        }
        return bl;
    }

    public static boolean moveDirectory(String string, String string2) {
        if (StringUtil.isNotEmpty((String)string) && StringUtil.isNotEmpty((String)string2)) {
            return FileUtil.moveDirectory(new File(string), new File(string2));
        }
        return false;
    }

    public static boolean moveDirectory(File file, File file2) {
        boolean bl = false;
        try {
            if (file2.exists()) {
                FileUtil.copyDirectory(file, file2);
                FileUtil.deleteDirectory(file);
            } else {
                FileUtils.moveDirectory((File)file, (File)file2);
            }
            bl = true;
        }
        catch (Exception exception) {
            a.error((Object)"moveDirectory error", (Throwable)exception);
        }
        return bl;
    }

    public static boolean copyDirectoryToDirectory(String string, String string2) {
        if (StringUtil.isNotEmpty((String)string) && StringUtil.isNotEmpty((String)string2)) {
            return FileUtil.copyDirectoryToDirectory(new File(string), new File(string2));
        }
        return false;
    }

    public static boolean copyDirectoryToDirectory(File file, File file2) {
        boolean bl = false;
        try {
            FileUtils.copyDirectoryToDirectory((File)file, (File)file2);
            bl = true;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            a.error((Object)new StringBuilder(52).append("copyDirectoryToDirectory(File, File)").append(string).toString());
        }
        return bl;
    }

    public static boolean moveDirectoryToDirectory(String string, String string2) {
        if (StringUtil.isNotEmpty((String)string) && StringUtil.isNotEmpty((String)string2)) {
            return FileUtil.moveDirectoryToDirectory(new File(string), new File(string2));
        }
        return false;
    }

    public static boolean moveDirectoryToDirectory(File file, File file2) {
        boolean bl = false;
        try {
            FileUtils.moveDirectoryToDirectory((File)file, (File)file2, (boolean)true);
            bl = true;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            a.error((Object)new StringBuilder(52).append("moveDirectoryToDirectory(File, File)").append(string).toString());
        }
        return bl;
    }

    public static boolean deleteFile(String string) {
        if (StringUtil.isNotEmpty((String)string)) {
            return FileUtil.deleteFile(new File(string));
        }
        return false;
    }

    public static boolean deleteFile(File file) {
        boolean bl = false;
        bl = file.delete();
        return bl;
    }

    public static FileInputStream openInputStream(File file) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileUtils.openInputStream((File)file);
        }
        catch (Exception exception) {
            a.error((Object)"\u83b7\u5f97FileInputStream\u5931\u8d25");
        }
        return fileInputStream;
    }

    public static FileOutputStream openOutputStream(File file) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = FileUtils.openOutputStream((File)file);
        }
        catch (Exception exception) {
            a.error((Object)"\u83b7\u5f97FileOutputStream\u5931\u8d25");
        }
        return fileOutputStream;
    }

    public static boolean deleteFiles(Collection<File> collection) {
        for (File file : collection) {
            file.delete();
        }
        return true;
    }

    public static boolean deleteDirectory(File file) {
        boolean bl = false;
        try {
            FileUtils.deleteDirectory((File)file);
            bl = true;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            a.error((Object)new StringBuilder(31).append("deleteDir(File)").append(string).toString());
        }
        return bl;
    }

    public static boolean cleanDirectory(File file) {
        boolean bl = false;
        try {
            FileUtils.cleanDirectory((File)file);
            bl = true;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            a.error((Object)new StringBuilder(36).append("cleanDirectory(File)").append(string).toString());
        }
        return bl;
    }

    public static long sizeOfDirectory(File file) {
        return FileUtils.sizeOfDirectory((File)file);
    }

    public static boolean writeStringToFile(File file, String string, String string2) {
        return FileUtil.writeStringToFile(file, string, string2, false);
    }

    public static boolean writeStringToFile(File file, String string, String string2, boolean bl) {
        boolean bl2 = false;
        try {
            if (file.getName().contains("\u0000")) {
                return false;
            }
            if (string2 == null || string2.trim().length() == 0) {
                string2 = "utf-8";
            }
            String string3 = file.getPath();
            a.debug((Object)new StringBuilder(34).append("writeStringToFile:").append(string3).toString());
            FileUtils.writeStringToFile((File)file, (String)string, (String)string2, (boolean)bl);
            bl2 = true;
        }
        catch (Exception exception) {
            String string4 = exception.getMessage();
            a.error((Object)new StringBuilder(61).append("writeStringToFile(File,String,String,boolean)").append(string4).toString());
        }
        return bl2;
    }

    public static boolean writeStringToFile(String string, String string2) {
        boolean bl = false;
        if (StringUtil.isNotEmpty((String)string)) {
            File file = new File(string);
            bl = FileUtil.writeStringToFile(file, string2, null);
        }
        return bl;
    }

    public static boolean writeStringToFile(File file, String string) {
        return FileUtil.writeStringToFile(file, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeInputStreamToFile(File file, InputStream inputStream) {
        boolean bl;
        block7: {
            bl = false;
            FileOutputStream fileOutputStream = null;
            try {
                if (file.getName().contains("\u0000")) {
                    boolean bl2 = false;
                    return bl2;
                }
                fileOutputStream = new FileOutputStream(file);
                IOUtils.write((byte[])IOUtils.toByteArray((InputStream)inputStream), (OutputStream)fileOutputStream);
                bl = true;
                IOUtils.closeQuietly((OutputStream)fileOutputStream);
            }
            catch (Exception exception) {
                a.error((Object)"writeInputStreamToFile error", (Throwable)exception);
                break block7;
            }
            finally {
                IOUtils.closeQuietly(fileOutputStream);
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return bl;
    }

    public static List<String> readLines(File file, String string) {
        try {
            if (string == null || string.trim().length() == 0) {
                return FileUtils.readLines((File)file, (String)"utf-8");
            }
            return FileUtils.readLines((File)file, (String)string);
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            a.error((Object)new StringBuilder(38).append("readLines(File,String)").append(string2).toString());
            return null;
        }
    }

    public static List<String> readLines(File file) {
        return FileUtil.readLines(file, null);
    }

    public static String readResource(String string, String string2) {
        String string3 = null;
        try {
            string3 = IOUtils.toString((InputStream)FileUtil.class.getResourceAsStream(string), (String)string2);
        }
        catch (Exception exception) {
            a.error((Object)"readResource error", (Throwable)exception);
        }
        return string3;
    }

    public static String readResource(String string) {
        return FileUtil.readResource(string, "utf-8");
    }

    public static String readFileToString(File file, String string) {
        try {
            if (string == null || string.trim().length() == 0) {
                return FileUtils.readFileToString((File)file, (String)"utf-8");
            }
            return FileUtils.readFileToString((File)file, (String)string);
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            a.error((Object)new StringBuilder(38).append("readLines(File,String)").append(string2).toString());
            return null;
        }
    }

    public static String readFileToString(File file) {
        return FileUtil.readFileToString(file, null);
    }

    public static String readFileToString(String string) {
        if (StringUtil.isNotEmpty((String)string)) {
            return FileUtil.readFileToString(new File(string), null);
        }
        return null;
    }

    public static String readFileToString(String string, String string2) {
        if (StringUtil.isNotEmpty((String)string)) {
            return FileUtil.readFileToString(new File(string), string2);
        }
        return null;
    }

    public static List<File> filterFiles(File file, String[] stringArray, boolean bl) {
        List list = (List)FileUtils.listFiles((File)file, (String[])stringArray, (boolean)bl);
        return list;
    }

    public static List<File> listFiles(String string, String string2, boolean bl, Integer n, Integer n2, Integer n3, boolean bl2, int n4) {
        return FileUtil.listFiles(string, string2, bl, n, n2, n3, bl2, true, n4);
    }

    public static List<File> listFiles(String string, String string2, boolean bl, Integer n, Integer n2, Integer n3, boolean bl2) {
        return FileUtil.listFiles(string, string2, bl, n, n2, n3, bl2, true, 5);
    }

    public static List<File> listFiles(String string, String string2, boolean bl, Integer n, Integer n2, Integer n3, final boolean bl2, boolean bl3, int n4) {
        File file = new File(string);
        List<Object> list = null;
        Object[] objectArray = null;
        if (!file.isDirectory() || n4 == 0) {
            return list;
        }
        if (n != null && n <= 0) {
            return list;
        }
        if (n2 != null && n2 <= 0) {
            return list;
        }
        if (StringUtil.isEmpty((String)string2)) {
            objectArray = file.listFiles();
        } else {
            Object[] objectArray2 = string2.toLowerCase();
            objectArray = file.listFiles(new FilenameFilter((String)objectArray2){
                final /* synthetic */ String a;
                {
                    this.a = string;
                }

                @Override
                public boolean accept(File file, String string) {
                    return (string = string.toLowerCase()).contains(this.a);
                }
            });
        }
        if (ArrayUtils.isNotEmpty((Object[])objectArray)) {
            list = new ArrayList<Object>(Arrays.asList(objectArray));
            if (bl) {
                --n4;
                for (Object object : objectArray) {
                    List<File> list2 = FileUtil.listFiles(((File)object).getAbsolutePath(), string2, bl, n, n2, n3, bl2, false, n4);
                    if (!CollectionUtils.isNotEmpty(list2)) continue;
                    list.addAll(list2);
                }
            }
            if (bl3) {
                final int n5 = NumberUtil.getInt((Object)n3, (int)1);
                Collections.sort(list, new Comparator<File>(){

                    public int a(File file, File file2) {
                        int n = 0;
                        switch (n5) {
                            case 1: {
                                if (file.isDirectory() && file2.isFile()) {
                                    n = -1;
                                    break;
                                }
                                if (file.isFile() && file2.isDirectory()) {
                                    n = 1;
                                    break;
                                }
                                n = file.compareTo(file2);
                                break;
                            }
                            case 2: {
                                if (file.isDirectory() && file2.isFile()) {
                                    n = -1;
                                    break;
                                }
                                if (file.isFile() && file2.isDirectory()) {
                                    n = 1;
                                    break;
                                }
                                long l = file.lastModified() - file2.lastModified();
                                if (l > 0L) {
                                    n = 1;
                                    break;
                                }
                                if (l == 0L) {
                                    n = 0;
                                    break;
                                }
                                n = -1;
                                break;
                            }
                            case 3: {
                                long l;
                                n = file.isDirectory() && file2.isFile() ? -1 : (file.isFile() && file2.isDirectory() ? 1 : (file.isDirectory() && file2.isDirectory() ? file.compareTo(file2) : ((l = file.length() - file2.length()) > 0L ? 1 : (l == 0L ? 0 : -1))));
                            }
                        }
                        if (bl2) {
                            n *= -1;
                        }
                        return n;
                    }

                    @Override
                    public /* synthetic */ int compare(Object object, Object object2) {
                        return this.a((File)object, (File)object2);
                    }
                });
                if (n != null && n2 != null && n > 0 && n2 > 0) {
                    int n6 = (n - 1) * n2;
                    if (n6 > list.size() - 1) {
                        return null;
                    }
                    int n7 = n6 + n2;
                    if (list.size() < n7) {
                        n7 = list.size();
                    }
                    list = list.subList(n6, n7);
                }
            }
        }
        return list;
    }

    public static byte[] readFileToByteArray(String string) {
        return FileUtil.readFileToByteArray(new File(string));
    }

    public static byte[] readFileToByteArray(File file) {
        byte[] byArray = null;
        try {
            byArray = FileUtils.readFileToByteArray((File)file);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            a.error((Object)new StringBuilder(21).append("\u6587\u4ef6\u672a\u627e\u5230").append(string).toString());
        }
        return byArray;
    }

    public static void writeByteArrayToFile(String string, byte[] byArray) {
        if (StringUtil.isNotEmpty((String)string)) {
            if (string.contains("\u0000")) {
                return;
            }
            FileUtil.writeByteArrayToFile(new File(string), byArray);
        }
    }

    public static void writeByteArrayToFile(File file, byte[] byArray) {
        try {
            if (file.getName().contains("\u0000")) {
                return;
            }
            FileUtils.writeByteArrayToFile((File)file, (byte[])byArray);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            a.error((Object)new StringBuilder(23).append("\u5199\u5165\u6587\u4ef6\u4e3a\u6210\u529f").append(string).toString());
        }
    }

    public static boolean isDirExsit(File file, boolean bl) {
        boolean bl2 = false;
        if (file.isDirectory() && file.exists()) {
            bl2 = true;
        } else if (bl) {
            file.mkdirs();
        }
        return bl2;
    }

    public static void createFile(File file) {
        if (file != null && !file.exists()) {
            try {
                FileUtils.touch((File)file);
            }
            catch (Exception exception) {
                a.error((Object)"createFile error", (Throwable)exception);
            }
        }
    }

    public static void createDir(String string) {
        File file;
        if (StringUtil.isNotEmpty((String)string) && !(file = new File(string)).exists()) {
            file.mkdirs();
        }
    }

    public static String getType(String string) {
        String string2 = null;
        int n = string.indexOf("?");
        String string3 = string;
        if (n > -1) {
            string3 = string3.substring(0, n);
        }
        if ((n = string3.lastIndexOf(".")) > -1) {
            string2 = string3.substring(n + 1, string3.length()).toLowerCase();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, byte[]> readContentFromJar(File file) {
        HashMap<String, byte[]> hashMap = null;
        ZipFile zipFile = null;
        InputStream inputStream = null;
        try {
            hashMap = new HashMap<String, byte[]>(0);
            zipFile = new JarFile(file);
            Enumeration<JarEntry> enumeration = ((JarFile)zipFile).entries();
            JarEntry jarEntry = null;
            while (enumeration.hasMoreElements()) {
                jarEntry = enumeration.nextElement();
                inputStream = ((JarFile)zipFile).getInputStream(jarEntry);
                hashMap.put(jarEntry.getName(), IOUtils.toByteArray((InputStream)inputStream));
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        catch (Exception exception) {
            a.error((Object)"\u8bfb\u53d6jar\u5305\u9519\u8bef", (Throwable)exception);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Exception exception) {
                    a.warn((Object)"\u5173\u95edjar\u8bfb\u53d6\u9519\u8bef\u4e86\u3002");
                }
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeContentToJar(File file, Map<String, byte[]> map) {
        boolean bl = false;
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new JarOutputStream(new FileOutputStream(file));
            Iterator<String> iterator = map.keySet().iterator();
            JarEntry jarEntry = null;
            String string = null;
            while (iterator.hasNext()) {
                string = iterator.next();
                jarEntry = new JarEntry(string);
                ((JarOutputStream)zipOutputStream).putNextEntry(jarEntry);
                zipOutputStream.write(map.get(string));
            }
            zipOutputStream.flush();
            bl = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            a.error((Object)"\u6587\u4ef6\u6ca1\u627e\u5230", (Throwable)fileNotFoundException);
        }
        catch (Exception exception) {
            a.error((Object)"JarOutputStream\u8bfb\u53d6\u5f02\u5e38", (Throwable)exception);
        }
        finally {
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (Exception exception) {
                    a.warn((Object)"\u5173\u95edJarOutputStream\u9519\u8bef\u4e86\u3002");
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObject(Object object, String string) {
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(object);
        }
        catch (Exception exception) {
            a.error((Object)"storeObject error", (Throwable)exception);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (Exception exception) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T readObject(String string) {
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        Object object = null;
        try {
            fileInputStream = new FileInputStream(string);
            objectInputStream = new ObjectInputStream(fileInputStream);
            object = objectInputStream.readObject();
        }
        catch (Exception exception) {
            a.error((Object)"readToDocument error", (Throwable)exception);
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (Exception exception) {}
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return (T)object;
    }

    public static String getExtension(File file) {
        String string = file.getName();
        return FileUtil.getExtension(string);
    }

    public static String getExtension(String string) {
        String string2 = null;
        if (StringUtil.isNotEmpty((String)string)) {
            String[] stringArray;
            if (string.contains("?") && (stringArray = string.split("\\?")).length > 0) {
                string = stringArray[0];
            }
            if (StringUtil.isNotEmpty((String)(string2 = FilenameUtils.getExtension((String)string)))) {
                string2 = string2.toLowerCase();
            }
        }
        return string2;
    }

    public static String getName(File file) {
        String string = file.getName();
        return FileUtil.getName(string);
    }

    public static String getName(String string) {
        String string2 = null;
        if (StringUtil.isNotEmpty((String)string)) {
            string2 = FilenameUtils.getName((String)string);
        }
        return string2;
    }

    public static String getSimpleName(File file) {
        String string = file.getName();
        return FileUtil.getSimpleName(string);
    }

    public static String getSimpleName(String string) {
        String string2 = null;
        if (StringUtil.isNotEmpty((String)string)) {
            string2 = FilenameUtils.getBaseName((String)string);
        }
        return string2;
    }

    public static String getMimeType(String string) {
        String string2 = null;
        if (StringUtil.isNotEmpty((String)string)) {
            String string3 = FileUtil.getExtension(string);
            if (StringUtil.isNotEmpty((String)string3)) {
                string2 = MimeTypeCache.getMimeType(string3);
            }
            if (StringUtil.isEmpty(string2)) {
                string2 = DEFAULT_MIMETYPE;
            }
        }
        return string2;
    }

    public static String getMimeType(File file) {
        String string = null;
        if (file != null) {
            String string2 = file.getAbsolutePath();
            string = FileUtil.getMimeType(string2);
        }
        return string;
    }

    public static String getFileMd5(File file) {
        String string = null;
        if (file != null && file.exists()) {
            try {
                byte[] byArray = FileUtils.readFileToByteArray((File)file);
                string = DigestUtils.md5Hex((byte[])byArray);
            }
            catch (Exception exception) {
                a.error((Object)"getFileMd5 error", (Throwable)exception);
            }
        }
        return string;
    }

    public static String getFileMd5(String string) {
        return FileUtil.getFileMd5(new File(string));
    }

    public static byte[] encrypt(File file, String string) {
        byte[] byArray = FileUtil.readFileToByteArray(file);
        return FileUtil.encrypt(byArray, string);
    }

    public static byte[] decrypt(File file, String string) {
        byte[] byArray = FileUtil.readFileToByteArray(file);
        return FileUtil.decrypt(byArray, string);
    }

    public static byte[] encrypt(byte[] byArray, String string) {
        return SmCryptoUtil.sm4Encode_ECB((byte[])byArray, (String)string);
    }

    public static byte[] decrypt(byte[] byArray, String string) {
        return SmCryptoUtil.sm4Decode_ECB((byte[])byArray, (String)string);
    }

    public static void encrypt(File file, String string, File file2) {
        byte[] byArray = FileUtil.readFileToByteArray(file);
        byArray = FileUtil.encrypt(byArray, string);
        FileUtil.writeByteArrayToFile(file2, byArray);
    }

    public static void decrypt(File file, String string, File file2) {
        byte[] byArray = FileUtil.readFileToByteArray(file);
        byArray = FileUtil.decrypt(byArray, string);
        FileUtil.writeByteArrayToFile(file2, byArray);
    }

    public static String getCharset(URL uRL) throws Exception {
        String string = null;
        CodepageDetectorProxy codepageDetectorProxy = CodepageDetectorProxy.getInstance();
        codepageDetectorProxy.add((ICodepageDetector)new ParsingDetector(false));
        codepageDetectorProxy.add(UnicodeDetector.getInstance());
        codepageDetectorProxy.add((ICodepageDetector)JChardetFacade.getInstance());
        codepageDetectorProxy.add(ASCIIDetector.getInstance());
        Charset charset = null;
        try {
            charset = codepageDetectorProxy.detectCodepage(uRL);
            if (charset != null) {
                string = charset.name().toLowerCase().equals("us-ascii") ? "iso-8859-1" : charset.name();
            }
        }
        catch (Exception exception) {
            a.error((Object)"getCharset error", (Throwable)exception);
        }
        return string;
    }

    public static String getCharset(File file) throws Exception {
        return FileUtil.getCharset(file.toURI().toURL());
    }

    public static boolean writeLine(File file, Collection<String> collection) {
        return FileUtil.writeLine(file, collection, false);
    }

    public static boolean writeLine(File file, Collection<String> collection, boolean bl) {
        boolean bl2 = false;
        try {
            FileUtils.writeLines((File)file, collection, (boolean)bl);
            bl2 = true;
        }
        catch (Exception exception) {
            a.error((Object)"writeLine error", (Throwable)exception);
        }
        return bl2;
    }

    private static String a(String string) {
        string = StringUtil.getString((Object)string);
        string = StringUtil.convertPath((String)string, (boolean)false);
        string = string.replaceAll("\\.+", ".");
        return string;
    }

    public static File safeInstance(String string) {
        return new File(FileUtil.a(string));
    }

    public static File safeInstance(String string, String string2) {
        return new File(FileUtil.a(string), FileUtil.a(string2));
    }

    public static File safeInstance(File file, String string) {
        return new File(file, FileUtil.a(string));
    }

    public static FileOutputStream safeInstanceOutputStream(String string) throws FileNotFoundException {
        return new FileOutputStream(FileUtil.a(string));
    }

    public static FileOutputStream safeInstanceOutputStream(String string, boolean bl) throws FileNotFoundException {
        return new FileOutputStream(FileUtil.a(string), bl);
    }

    public static FileInputStream safeInstanceInputStream(String string) throws FileNotFoundException {
        return new FileInputStream(FileUtil.a(string));
    }

    public static void lineIterator(String string, int n, LineProcessor lineProcessor) {
        FileUtil.lineIterator(new File(string), n, lineProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lineIterator(File file, int n, LineProcessor lineProcessor) {
        ArrayList arrayList = new ArrayList(1);
        LineIterator lineIterator = null;
        try {
            lineIterator = FileUtils.lineIterator((File)file);
            FileUtil.a(lineIterator, n, lineProcessor);
        }
        catch (Exception exception) {
            a.error((Object)"lineIterator error", (Throwable)exception);
        }
        finally {
            try {
                lineIterator.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void lineIterator(InputStream inputStream, int n, LineProcessor lineProcessor) {
        LineIterator lineIterator = IOUtils.lineIterator((InputStream)inputStream, (String)"utf-8");
        FileUtil.a(lineIterator, n, lineProcessor);
    }

    private static void a(LineIterator lineIterator, int n, LineProcessor lineProcessor) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        while (lineIterator.hasNext()) {
            String string = lineIterator.next();
            arrayList.add(string);
            if (arrayList.size() < n) continue;
            lineProcessor.readLines(arrayList);
            arrayList.clear();
        }
        if (CollectionUtil.isNotEmpty(arrayList)) {
            lineProcessor.readLines(arrayList);
            arrayList.clear();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        CSVParser cSVParser = CSVFormat.DEFAULT.withHeader(new String[]{"\u9519\u522b\u5b57", "\u5e94\u4fee\u6539\u4e3a", "\u5730\u5740", "\u662f\u5426\u5ffd\u89c6", "\u6240\u5728\u6bb5\u843d", "\u662f\u5426\u9644\u4ef6", "\u9519\u522b\u5b57\u7f16\u7801"}).parse((Reader)new FileReader(new File("/home/lijie/\u684c\u9762/\u5c71\u4e1c\u7701\u79d1\u5b66\u6280\u672f\u534f\u4f1a.csv")));
        List list = cSVParser.getRecords();
        for (int i = 1; i < list.size(); ++i) {
            CSVRecord cSVRecord = (CSVRecord)list.get(i);
            String string = cSVRecord.get("\u9519\u522b\u5b57");
            String string2 = cSVRecord.get("\u5e94\u4fee\u6539\u4e3a");
            String string3 = cSVRecord.get("\u5730\u5740");
            String string4 = cSVRecord.get("\u662f\u5426\u5ffd\u89c6");
            String string5 = cSVRecord.get("\u9519\u522b\u5b57\u7f16\u7801");
            String string6 = cSVRecord.get("\u6240\u5728\u6bb5\u843d");
            if (StringUtil.equals((String)string4, (String)"2")) continue;
            Document document = Jsoup.parse((URL)new URL(string3), (int)30000);
            String string7 = document.body().text();
            System.out.println(string7);
            int n = string7.indexOf(string6);
            String string8 = string2;
            String string9 = string;
            System.out.println(new StringBuilder(33).append(string9).append("\t").append(string8).toString());
            System.out.println(string7.substring(n, n + string6.length()));
            break;
        }
    }

    public static interface LineProcessor {
        public void readLines(List<String> var1);
    }
}

