/*
 * Decompiled with CFR 0.152.
 */
package com.hanweb.common.util;

import com.hanweb.common.util.StringUtil;
import com.hanweb.common.util.log.Log;
import com.hanweb.common.util.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;

@Component(value="SpringUtil")
public class SpringUtil {
    private static Log a = LogFactory.getInstance(SpringUtil.class);
    private static ApplicationContext b;
    private static MessageSource c;

    @Autowired
    public SpringUtil(ApplicationContext applicationContext, MessageSource messageSource) {
        String[] stringArray;
        System.out.println("init SpringUtil");
        System.setProperty("springfox.documentation.auto-startup", "false");
        b = applicationContext;
        c = messageSource;
        for (String string : stringArray = applicationContext.getEnvironment().getActiveProfiles()) {
            if (!StringUtil.equalsIgnoreCase(string, "dev") && !StringUtil.equalsIgnoreCase(string, "local")) continue;
            System.setProperty("springfox.documentation.auto-startup", "true");
            break;
        }
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)(b == null ? null : b.getBean(clazz));
    }

    public static <T> Collection<T> getBeans(Class<T> clazz) {
        ArrayList arrayList = new ArrayList();
        if (b == null) {
            return arrayList;
        }
        Collection collection = b.getBeansOfType(clazz).values();
        if (collection != null) {
            arrayList.addAll(collection);
            SpringUtil.sortBeans(arrayList);
        }
        return arrayList;
    }

    public static <T> void sortBeans(List<T> list) {
        if (list != null) {
            Collections.sort(list, AnnotationAwareOrderComparator.INSTANCE);
        }
    }

    public static Object getBean(String string) {
        return b.getBean(string);
    }

    public static <T> T getBean(String string, Class<T> clazz) {
        if (b.containsBean(string)) {
            return (T)b.getBean(string, clazz);
        }
        return null;
    }

    public static <T> T getTargetObject(Object object, Class<T> clazz) {
        Object object2 = null;
        a.debug("isAopProxy {0}", AopUtils.isAopProxy((Object)object));
        try {
            object2 = AopUtils.isJdkDynamicProxy((Object)object) ? ((Advised)object).getTargetSource().getTarget() : object;
        }
        catch (Exception exception) {
            a.error((Object)"getTargetObject error", exception);
        }
        return (T)object2;
    }

    public static String getMessage(String string) {
        return SpringUtil.a(string, new Object[0]);
    }

    public static String getMessage(String string, Object ... objectArray) {
        return SpringUtil.a(string, objectArray);
    }

    private static String a(String string, Object ... objectArray) {
        if (b == null) {
            return string;
        }
        HttpServletRequest httpServletRequest = SpringUtil.getRequest();
        Locale locale = null;
        if (httpServletRequest != null) {
            locale = SpringUtil.getBean(SessionLocaleResolver.class).resolveLocale(SpringUtil.getRequest());
        }
        if (locale == null) {
            locale = Locale.CHINA;
        }
        String string2 = null;
        string = StringUtil.getString(string);
        string2 = b == null ? string : c.getMessage(string, objectArray, locale);
        return string2;
    }

    public static ApplicationContext getApplicationContext() {
        return b;
    }

    public static HttpServletRequest getRequest() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest httpServletRequest = null;
        if (servletRequestAttributes != null) {
            httpServletRequest = servletRequestAttributes.getRequest();
        }
        return httpServletRequest;
    }

    public static HttpServletResponse getResponse() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletResponse httpServletResponse = null;
        if (servletRequestAttributes != null) {
            httpServletResponse = servletRequestAttributes.getResponse();
        }
        return httpServletResponse;
    }

    public static String getActiveProfile() {
        return SpringUtil.getEnvProperty("spring.profiles.active");
    }

    public static String getEnvProperty(String string) {
        return b.getEnvironment().getProperty(string);
    }

    public static String getAppName() {
        return SpringUtil.getEnvProperty("spring.application.name");
    }

    public static <T> T registerBean(String string, Class<T> clazz, Object ... abstractBeanDefinition) {
        if (!b.containsBean(string)) {
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
            if (((Object[])abstractBeanDefinition).length > 0) {
                for (AbstractBeanDefinition abstractBeanDefinition2 : abstractBeanDefinition) {
                    beanDefinitionBuilder.addConstructorArgValue((Object)abstractBeanDefinition2);
                }
            }
            AbstractBeanDefinition abstractBeanDefinition3 = beanDefinitionBuilder.getRawBeanDefinition();
            DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)b.getAutowireCapableBeanFactory();
            defaultListableBeanFactory.registerBeanDefinition(string, (BeanDefinition)abstractBeanDefinition3);
        }
        return (T)b.getBean(string, clazz);
    }
}

