/*
 * Decompiled with CFR 0.152.
 */
package com.hanweb.common.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.hanweb.common.util.StringUtil;
import com.hanweb.common.util.json.Type;
import com.hanweb.common.util.log.Log;
import com.hanweb.common.util.log.LogFactory;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class JsonUtil {
    private static Log a = LogFactory.getInstance(JsonUtil.class);
    protected static ObjectMapper objectMapper = null;

    public static String objectToString(Object object) {
        if (object == null) {
            return null;
        }
        String string = null;
        try {
            string = objectMapper.writeValueAsString(object);
        }
        catch (Exception exception) {
            a.error((Object)"ObjectToString error", exception);
        }
        return string;
    }

    public static <T> T StringToObject(String string, Class<T> clazz) {
        if (StringUtil.isEmpty(string)) {
            return null;
        }
        Object object = null;
        try {
            object = objectMapper.readValue(string, clazz);
        }
        catch (Exception exception) {
            a.error((Object)"StringToObject error", exception);
        }
        return (T)object;
    }

    public static <T> T StringToObject(String string, Type<T> type) {
        if (StringUtil.isEmpty(string)) {
            return null;
        }
        Object object = null;
        try {
            object = objectMapper.readValue(string, type);
        }
        catch (Exception exception) {
            a.error((Object)"StringToObject error", exception);
        }
        return (T)object;
    }

    @Deprecated
    public static <T> T StringToObject(String string, TypeReference<T> typeReference) {
        if (StringUtil.isEmpty(string)) {
            return null;
        }
        Object object = null;
        try {
            object = objectMapper.readValue(string, typeReference);
        }
        catch (Exception exception) {
            a.error((Object)"StringToObject error", exception);
        }
        return (T)object;
    }

    public static <T> List<T> StringToList(String string, Class<?> ... classArray) {
        if (StringUtil.isEmpty(string)) {
            return null;
        }
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(ArrayList.class, (Class[])classArray);
        List list = null;
        try {
            list = (List)objectMapper.readValue(string, javaType);
        }
        catch (Exception exception) {
            a.error((Object)"StringToObject error", exception);
        }
        return list;
    }

    public static String getValue(String string, String string2) {
        if (StringUtil.isEmpty(string) && StringUtil.isNotEmpty(string2)) {
            return null;
        }
        String string3 = null;
        try {
            JsonNode jsonNode = objectMapper.readTree(string);
            jsonNode = jsonNode.findPath(string2);
            if (jsonNode != null) {
                string3 = jsonNode.asText();
            }
        }
        catch (Exception exception) {
            a.error((Object)"getValue error", exception);
        }
        return string3;
    }

    public static <T> T getValueFromPath(String string, String string2) {
        if (StringUtil.isEmpty(string) && StringUtil.isNotEmpty(string2)) {
            return null;
        }
        Object object = null;
        try {
            object = JsonPath.read((String)string, (String)string2, (Predicate[])new Predicate[0]);
        }
        catch (Exception exception) {
            String string3 = exception.getMessage();
            a.error(new StringBuilder(31).append("getValue error:").append(string3).toString());
        }
        return (T)object;
    }

    static {
        objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){
            private JsonProvider a = null;
            private MappingProvider b = null;

            public JsonProvider jsonProvider() {
                if (this.a == null) {
                    this.a = new JacksonJsonProvider(objectMapper);
                }
                return this.a;
            }

            public MappingProvider mappingProvider() {
                if (this.b == null) {
                    this.b = new JacksonMappingProvider(objectMapper);
                }
                return this.b;
            }

            public Set<Option> options() {
                return EnumSet.noneOf(Option.class);
            }
        });
    }
}

