/*
 * Decompiled with CFR 0.152.
 */
package com.hanweb.common.util;

import com.hanweb.common.util.log.ThreadLocalHolder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public class CompletableFutureHandler<T>
extends CompletableFuture<T> {
    public static <U> CompletableFuture<U> supplyAsyncWithTrace(Supplier<U> supplier) {
        String string = ThreadLocalHolder.getTraceId();
        Supplier<Object> supplier2 = () -> {
            ThreadLocalHolder.createTraceId(string);
            return supplier.get();
        };
        return CompletableFuture.supplyAsync(supplier2);
    }

    public static <U> CompletableFuture<U> supplyAsyncWithTrace(final Supplier<U> supplier, Executor executor) {
        final String string = ThreadLocalHolder.getTraceId();
        Supplier supplier2 = new Supplier<U>(){

            @Override
            public U get() {
                ThreadLocalHolder.createTraceId(string);
                return supplier.get();
            }
        };
        return CompletableFuture.supplyAsync(supplier2, executor);
    }

    public static CompletableFuture<Void> runAsyncWithTrace(final Runnable runnable) {
        final String string = ThreadLocalHolder.getTraceId();
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                ThreadLocalHolder.createTraceId(string);
                runnable.run();
            }
        };
        return CompletableFuture.runAsync(runnable2);
    }

    public static CompletableFuture<Void> runAsyncWithTrace(final Runnable runnable, Executor executor) {
        final String string = ThreadLocalHolder.getTraceId();
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                ThreadLocalHolder.createTraceId(string);
                runnable.run();
            }
        };
        return CompletableFuture.runAsync(runnable2, executor);
    }
}

