/*
 * Decompiled with CFR 0.152.
 */
package com.hanweb.common.util;

import com.hanweb.common.annotation.AnnotationBean;
import com.hanweb.common.util.log.Log;
import com.hanweb.common.util.log.LogFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.core.annotation.AnnotationUtils;

public class AnnotationUtil {
    private static Log a = LogFactory.getInstance(AnnotationUtil.class);

    public static <T extends Annotation> T findAnnotationFromMethod(Class<?> clazz, String string, Class<T> clazz2) {
        T t = null;
        try {
            Method method = clazz.getMethod(string, new Class[0]);
            t = method.getAnnotation(clazz2);
        }
        catch (Exception exception) {
            a.error((Object)"\u83b7\u5f97\u65b9\u6cd5\u7684\u6ce8\u91ca\u51fa\u9519", exception);
        }
        return t;
    }

    public static <T extends Annotation> T findAnnotationFromField(Class<?> clazz, String string, Class<T> clazz2) {
        T t = null;
        try {
            Field field = clazz.getDeclaredField(string);
            t = field.getAnnotation(clazz2);
        }
        catch (Exception exception) {
            a.error((Object)"\u83b7\u5f97\u5c5e\u6027\u7684\u6ce8\u91ca\u51fa\u9519", exception);
        }
        return t;
    }

    public static <T extends Annotation> T findAnnotationFromClass(Class<?> clazz, Class<T> clazz2) {
        T t = null;
        try {
            t = clazz.getAnnotation(clazz2);
        }
        catch (Exception exception) {
            a.error((Object)"\u83b7\u5f97\u5c5e\u6027\u7684\u6ce8\u91ca\u51fa\u9519", exception);
        }
        return t;
    }

    public static <T extends Annotation> T findAnnotationFromSuperClass(Class<?> clazz, Class<T> clazz2) {
        T t = null;
        try {
            t = clazz.getSuperclass().getAnnotation(clazz2);
        }
        catch (Exception exception) {
            a.error((Object)"\u83b7\u5f97\u5c5e\u6027\u7684\u6ce8\u91ca\u51fa\u9519", exception);
        }
        return t;
    }

    public static <T extends Annotation> List<AnnotationBean<T>> findAnnotationFromFields(Class<?> clazz, Class<T> clazz2) {
        return AnnotationUtil.findAnnotationFromFields(clazz, clazz2, true);
    }

    public static <T extends Annotation> List<AnnotationBean<T>> findAnnotationFromFields(Class<?> clazz, Class<T> clazz2, boolean bl) {
        Object object;
        Class<Object> clazz3;
        ArrayList<AnnotationBean<T>> arrayList = new ArrayList<AnnotationBean<T>>();
        Field[] fieldArray = clazz.getDeclaredFields();
        if (fieldArray != null) {
            clazz3 = null;
            object = null;
            for (Field field : fieldArray) {
                clazz3 = field.getAnnotation(clazz2);
                if (clazz3 == null) continue;
                object = new AnnotationBean();
                ((AnnotationBean)object).setName(field.getName());
                ((AnnotationBean)object).setFieldType(field.getType());
                ((AnnotationBean)object).setAnnotation(clazz3);
                ((AnnotationBean)object).setField(field);
                arrayList.add((AnnotationBean<T>)object);
            }
        }
        if (bl && (clazz3 = clazz.getSuperclass()) != null && clazz3 != Object.class) {
            object = AnnotationUtil.findAnnotationFromFields(clazz3, clazz2, bl);
            Iterator<AnnotationBean<T>> iterator = object.iterator();
            while (iterator.hasNext()) {
                AnnotationBean annotationBean = (AnnotationBean)iterator.next();
                if (arrayList.contains(annotationBean)) continue;
                arrayList.add(annotationBean);
            }
            object.clear();
        }
        return arrayList;
    }

    public static List<Field> findNoAnnotationFields(Class<?> clazz) {
        ArrayList<Field> arrayList = null;
        Field[] fieldArray = clazz.getDeclaredFields();
        Object[] objectArray = null;
        if (fieldArray != null) {
            arrayList = new ArrayList<Field>();
            for (Field field : fieldArray) {
                objectArray = field.getAnnotations();
                if (!ArrayUtils.isEmpty((Object[])objectArray)) continue;
                arrayList.add(field);
            }
        }
        return arrayList;
    }

    public static <T extends Annotation> AnnotationBean<T> findAnnotationFromField(Class<?> clazz, Class<T> clazz2) {
        AnnotationBean annotationBean = null;
        Field[] fieldArray = clazz.getDeclaredFields();
        if (fieldArray != null) {
            Object t = null;
            for (Field field : fieldArray) {
                t = field.getAnnotation(clazz2);
                if (t == null) continue;
                annotationBean = new AnnotationBean();
                annotationBean.setName(field.getName());
                annotationBean.setFieldType(field.getType());
                annotationBean.setAnnotation(t);
                annotationBean.setField(field);
                break;
            }
        }
        return annotationBean;
    }

    public static <T extends Annotation> boolean isThisAnnotation(Class<?> clazz, Class<T> clazz2) {
        return clazz.isAnnotationPresent(clazz2);
    }

    public static Object getValue(Annotation annotation, String string) {
        return AnnotationUtils.getValue((Annotation)annotation, (String)string);
    }

    public static boolean hasValue(Annotation annotation, String string) {
        return AnnotationUtil.getValue(annotation, string) != null;
    }
}

