/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.ofd.custom.agent;

import com.suwell.ofd.custom.agent.HTTPConvertConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConvertConfig
implements HTTPConvertConfig {
    private static Logger log = LoggerFactory.getLogger(DefaultConvertConfig.class);
    private static int connectTimeoutInMissecond = 5000;
    private static int readTimeoutInMissecond = 300000;
    private static int maxThreadCount = 10;

    @Override
    public int getMaxThreadCount() {
        return maxThreadCount;
    }

    @Override
    public int getConnectTimeoutInMissecond(String url, int len) {
        return connectTimeoutInMissecond;
    }

    @Override
    public int getReadTimeoutInMissecond(String url, int len) {
        return readTimeoutInMissecond;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties load(Class<?> c, String name) {
        Properties p = new Properties();
        InputStream is = null;
        try {
            if (name != null) {
                is = c.getResourceAsStream(name);
            }
            if (is != null) {
                p.load(new InputStreamReader(is, "UTF-8"));
            }
            Properties properties = p;
            return properties;
        }
        catch (IOException e) {
            Properties properties = null;
            return properties;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    static {
        Properties p = DefaultConvertConfig.load(DefaultConvertConfig.class, "/" + DefaultConvertConfig.class.getSimpleName() + ".properties");
        try {
            connectTimeoutInMissecond = Integer.valueOf(p.getProperty("ConnectTimeoutInMissecond", "5000"));
            readTimeoutInMissecond = Integer.valueOf(p.getProperty("ReadTimeoutInMissecond", "300000"));
            maxThreadCount = Integer.valueOf(p.getProperty("MaxThreadCount", "10"));
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
    }
}

