/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.ofd.custom.agent;

import com.google.gson.Gson;
import com.suwell.ofd.custom.agent.ConvertAgent;
import com.suwell.ofd.custom.agent.ConvertCallback;
import com.suwell.ofd.custom.agent.ConvertException;
import com.suwell.ofd.custom.agent.DefaultConvertConfig;
import com.suwell.ofd.custom.agent.HTTPConvertConfig;
import com.suwell.ofd.custom.agent.HttpRequest;
import com.suwell.ofd.custom.agent.Model;
import com.suwell.ofd.custom.agent.ResultException;
import com.suwell.ofd.custom.wrapper.Packet;
import com.suwell.ofd.custom.wrapper.io.IOTools;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomAgent
extends ConvertAgent {
    private static Logger log = LoggerFactory.getLogger(AtomAgent.class);
    private static Semaphore semaphore = new Semaphore(10);
    private static final String defaultCharset = "utf-8";
    private static final String atom = "atom/convert";
    private static final String formbuilder = "atom/formbuilder";
    private static final String submit = "quick/submit";
    private static final String STATUS_MEG = "Suwell-Result";
    private static final int ERROE_CODE = 700;
    private static HTTPConvertConfig config = new DefaultConvertConfig();
    private String baseURL;

    public static void init(HTTPConvertConfig config) {
        AtomAgent.config = config;
        if (config.getMaxThreadCount() > 0) {
            semaphore = new Semaphore(config.getMaxThreadCount());
        }
    }

    public AtomAgent(String url) {
        log.debug("Base url {}", (Object)this.baseURL);
        this.baseURL = url;
        if (!this.baseURL.endsWith("/")) {
            this.baseURL = this.baseURL + "/";
        }
    }

    public String submit(InputStream packet, String token, boolean raise) throws IOException {
        try {
            Model m = AtomAgent.submit(packet, "packet", this.baseURL);
            if (m.getCode() != 1002 && m.getCode() != 0) {
                throw new ResultException(m);
            }
            return m.getTicket();
        }
        catch (Exception e) {
            IOException ioe = e instanceof IOException ? (IOException)e : new IOException(e);
            throw ioe;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void convert(InputStream packet, OutputStream result, String token, boolean raise) throws ConvertException, IOException {
        InputStream in = null;
        try {
            in = AtomAgent.atomConvert(packet, "packet", this.baseURL);
            IOTools.copy((InputStream)in, (OutputStream)result);
            result.flush();
        }
        catch (ResultException re) {
            try {
                throw new ConvertException(re.getMessage(), (Throwable)re);
                catch (Exception e) {
                    throw new IOException(e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                IOTools.closeQuietly(in);
                throw throwable;
            }
        }
        IOTools.closeQuietly((Closeable)in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formbuilder(Packet packet, OutputStream out) throws Exception {
        semaphore.acquire();
        try {
            InputStream inputStream = AtomAgent.store((Packet)packet);
            HttpRequest hr = HttpRequest.post(this.baseURL + formbuilder).trustAllCerts().trustAllHosts().connectTimeout(config.getConnectTimeoutInMissecond(this.baseURL, inputStream.available())).readTimeout(config.getReadTimeoutInMissecond(this.baseURL, inputStream.available()));
            hr.part("file", "formbuilder", null, inputStream);
            if (hr.code() != 200) {
                if (hr.code() == 700) {
                    throw new ResultException((Model)new Gson().fromJson(hr.body(defaultCharset), Model.class));
                }
                throw new HttpRequest.HttpRequestException(new IOException(hr.body(defaultCharset)));
            }
            IOTools.copy((InputStream)hr.buffer(), (OutputStream)out);
            out.flush();
        }
        finally {
            semaphore.release();
        }
    }

    public void convert(Packet packet, String target) throws ConvertException, IOException {
        Closeable in = null;
        try {
            AtomAgent.atomConvert(AtomAgent.store((Packet)packet), "packet", this.baseURL, target);
        }
        catch (ResultException re) {
            throw new ConvertException(re.getMessage(), (Throwable)re);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        finally {
            IOTools.closeQuietly(in);
        }
    }

    public void convertNoWait(final InputStream packet, final ConvertCallback callback, final String token, final boolean raise) throws IOException {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.onStart();
                    AtomAgent.this.convert(packet, callback.openOutput(), token, raise);
                    callback.onSuccess();
                }
                catch (Exception e) {
                    if (e instanceof ConvertException) {
                        ResultException tb = (ResultException)e.getCause();
                        callback.onFailed(tb.getResult().getCode() + "", tb.getResult().getMessage());
                    } else {
                        callback.onException(e);
                    }
                }
                finally {
                    callback.onFinally();
                }
            }
        });
    }

    static Model submit(InputStream packet, String name, String url) throws Exception {
        HttpRequest hr = HttpRequest.post(url + submit).trustAllCerts().trustAllHosts().connectTimeout(config.getConnectTimeoutInMissecond(url, packet.available())).readTimeout(config.getReadTimeoutInMissecond(url, packet.available())).part("file", name, null, packet);
        if (hr.code() != 200) {
            if (hr.code() == 700) {
                throw new ResultException((Model)new Gson().fromJson(hr.body(defaultCharset), Model.class));
            }
            throw new HttpRequest.HttpRequestException(new IOException(hr.body(defaultCharset)));
        }
        String body = hr.body(defaultCharset);
        return (Model)new Gson().fromJson(body, Model.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void atomConvert(InputStream packet, String name, String url, String target) throws Exception {
        semaphore.acquire();
        try {
            HttpRequest hr = HttpRequest.post(url + atom).trustAllCerts().trustAllHosts().connectTimeout(config.getConnectTimeoutInMissecond(url, packet.available())).readTimeout(config.getReadTimeoutInMissecond(url, packet.available()));
            hr.part("file", name, null, packet);
            hr.part("target", target);
            if (hr.code() != 200) {
                if (hr.code() == 700) {
                    throw new ResultException((Model)new Gson().fromJson(hr.body(defaultCharset), Model.class));
                }
                throw new HttpRequest.HttpRequestException(new IOException(hr.body(defaultCharset)));
            }
        }
        finally {
            semaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static InputStream atomConvert(InputStream packet, String name, String url) throws Exception {
        semaphore.acquire();
        try {
            HttpRequest hr = HttpRequest.post(url + atom).trustAllCerts().trustAllHosts().connectTimeout(config.getConnectTimeoutInMissecond(url, packet.available())).readTimeout(config.getReadTimeoutInMissecond(url, packet.available()));
            hr.part("file", name, null, packet);
            if (hr.code() != 200) {
                if (hr.code() == 700) {
                    throw new ResultException((Model)new Gson().fromJson(hr.body(defaultCharset), Model.class));
                }
                throw new HttpRequest.HttpRequestException(new IOException(hr.body(defaultCharset)));
            }
            BufferedInputStream bufferedInputStream = hr.buffer();
            return bufferedInputStream;
        }
        finally {
            semaphore.release();
        }
    }
}

